﻿#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma ModuleName=TiltAndBend
#pragma version=1.10

// https://www.wavemetrics.com/user/tony

// WARNING: this code OVERWRITES data!
// It's possible to severely distort a spectrum if you use the 'bend'
// option. See history area for a record of distortions. Changes can be
// undone from the commandline.

// How to use: select 'Tilt-Bend' from the trace menu. The vertical and
// horizontal scroll wheel (or touchpad equivalents) 'offset' and 'tilt'
// the spectrum by linear addition to the selected wave. 'Tilting' pivots
// the data about the x-position of the mouse cursor. If kAllowBend is
// set, use option-scroll to 'bend' the spectrum. 'Bending' adds a
// quadratic function centred at the position of the mouse cursor. The
// sum of additions is overprinted in the top left corner of the graph
// window and the mouse cursor appears as a four-arrow cursor while
// Tilt-Bend is active. Click anywhere in the graph window to halt
// bending and tilting actions. Expand the vertical axis to reduce the
// incremements for linear additions.

static constant kAllowBend=0 // whether to allow quadratic addition
static constant kShowAlert=1

menu "TracePopup"
	"Tilt-Bend", /Q, TiltAndBend#startTiltBend()
end

static function startTiltBend()
	
	// figure out graph and trace names
	GetLastUserMenuInfo
	
	wave w = TraceNameToWaveRef(S_graphName, S_traceName)
	
	if (NumberByKey("TYPE", TraceInfo(S_graphName, S_traceName,0)))
		DoAlert 0, S_traceName+" must be X-Y or waveform for tilt & bend!"
		return 0
	endif
	
	if(kShowAlert)
		DoAlert 1, "Are you sure you want to make changes to " + NameOfWave(w) + "?"
		if(v_flag == 2) //no
			return 0
		endif
	endif
	
	NewDataFolder/O root:Packages
	NewDataFolder/O root:Packages:TiltBendTrace
	DFREF dfr = root:Packages:TiltBendTrace
	
	string s_info = TraceInfo(S_graphName, S_traceName, 0)
	// save axis names
	string/G dfr:strXax = StringByKey("XAXIS",s_info)
	string/G dfr:strYax = StringByKey("YAXIS",s_info)
	
	
	
	Make/O/WAVE/N=2 dfr:w_ref /wave=w_ref
	w_ref={w, XWaveRefFromTrace(S_graphName, S_traceName)}
	Make/O/N=3 dfr:w_coeff /Wave=w_coeff // save coefficients for linear/cubic addition
	SetWindow $S_graphName hook(h_TiltBend)=TiltAndBend#TiltBendHook, hookevents=1
	TextBox/W=$S_graphName/K/N=TiltText
	string strTextbox
	string strPathToCoeff = GetWavesDataFolder(w_coeff, 2)
	if (kAllowBend)
		sprintf strTextbox, "\\K(3,52428,1)\\Zr150%s += \\{%s[0]}*x^2 + \\{%s[1]}*x + \\{%s[2]}\rclick to finish!", NameOfWave(w), strPathToCoeff, strPathToCoeff, strPathToCoeff
	else
		sprintf strTextbox, "\\K(3,52428,1)\\Zr150%s += \\{%s[1]}*x + \\{%s[2]}\rclick to finish!", NameOfWave(w), strPathToCoeff, strPathToCoeff
	endif
	TextBox/W=$S_graphName/N=TiltText/F=0/A=LT/X=5.00/Y=5.00 strTextbox
end

static function TiltBendHook(STRUCT WMWinHookStruct &s)
		
	int verbose=1, saveNote=1
	s.cursorCode = 8
	s.doSetCursor = 1
	
	DFREF dfr = root:Packages:TiltBendTrace
	if (DataFolderRefStatus(dfr) != 1)
		SetWindow $s.winName hook(h_TiltBend)=$"" // stop hook
		return 0
	endif
	
	wave w_coeff = dfr:w_coeff
	wave/WAVE w_ref = dfr:w_ref
	wave w = w_ref[0]
	wave/Z w_x = w_ref[1]
			
	if (s.eventCode == 3) // mouse click
		s.cursorCode = 0 // return mouse cursor to normal
		SetWindow $s.winName hook(h_TiltBend)=$"" // stop hook
		TextBox/W=$s.winName/K/N=TiltText
		if (w_coeff[0] || w_coeff[1] || w_coeff[2]) // w has been changed
			string strNote = "", strPrint = ""
			string strX = SelectString(WaveExists(w_x), "x", NameOfWave(w_x))
			
			if (w_coeff[0] != 0)
				sprintf strNote "quadratic addition:%g*%s^2%+g*%s%+g", w_coeff[0], strX, w_coeff[1], strX, w_coeff[2]
				sprintf strPrint "•%s += %g*%s^2%+g*%s%+g", NameOfWave(w), w_coeff[0], strX, w_coeff[1], strX, w_coeff[2]
			elseif (w_coeff[1] != 0)
				sprintf strNote "linear addition:%g*%s%+g", w_coeff[1], strX, w_coeff[2]
				sprintf strPrint "•%s += %g*%s%+g", NameOfWave(w), w_coeff[1], strX, w_coeff[2]
			else
				sprintf strNote "constant addition:%g", w_coeff[2]
				sprintf strPrint "•%s += %g", NameOfWave(w), w_coeff[2]
			endif
			
			if (saveNote)
				note w strNote
			endif
			if (verbose)
				Print strPrint
			endif
		endif
		
		KillDataFolder/Z root:Packages:TiltBendTrace
		return 0
	endif
	
	if (s.eventcode == 22) // mouse wheel
		
		SVAR strXax = dfr:strXax
		SVAR strYax = dfr:strYax
		GetAxis/W=$s.winName/Q $strXax
		variable xRange = v_max - v_min
		variable xMin = v_min, xMax = v_max
		GetAxis/W=$s.winName/Q $strYax
		variable yRange = v_max-v_min
		
		variable deltaM = yRange / xRange / 250
		variable deltaC = yRange / 500
		
		variable xPos = AxisValFromPixel(s.winName, strXax, s.mouseLoc.h)
		
		variable a, b, c // ax^2 + bx + c
		c = deltaC * s.wheelDy
		if (kAllowBend && (s.eventMod&4)) // option key: vert scroll bends
			variable y2 = deltaC*s.wheelDy
			variable dX = xPos-(xMax-xMin)/2
			xMax += dX; xMin += dX
			a = ( -xMin*y2 + xMax*y2 )/( (xMin-xPos)*(xMin-xMax)*(xPos-xMax) )
			b = y2/(xPos-xMin)-a*(xMin+xPos)
			c = -a*xMin^2 - b*xMin
		endif
		
		if (s.wheelDx) // horizontal scroll (or shift-scroll)
			// make linear addition to tilt
			b += deltaM * s.wheelDx
			c -= xPos*b
		endif
		
		if (WaveExists(w_x))
			w += a*w_x^2 + b*w_x + c
		else
			w += a*x^2 + b*x + c
		endif
		
		w_coeff[0] += a
		w_coeff[1] += b
		w_coeff[2] += c
	endif
	
	return 0
end
